/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.util;

import com.ibm.hwmca.base.rsf.util.TcpConnectionParms;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.rcs.conndata.ConnectivityInfo;
import com.ibm.hwmca.fw.rcs.conndata.ServerInfo;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TcpConnection {
    private static final String TRACE_T = "XRSFTCPT";
    private static final String TRACE_F = "XRSFTCPF";
    private static final String TRACE_D = "XRSFTCPD";
    private static final String TRACE_MASKT = "XRSFTCPT";
    private static final String TRACE_MASKF = "XRSFTCPF";
    private static final String TRACE_MASKD = "XRSFTCPD";
    public static final int RETAIN = 0;
    public static final int SERVICE_AGENT = 1;
    public static final int REMOTE_SUPPORT = 2;
    public static final int SYSTEM_AUTHENTICATION = 3;
    public static int MAX_SOCKET_CONNECT_RETRIES = 2;
    public static int MAX_SOCKET_IO_RETRIES = 2;
    private static final String INVALID_CIPHER_SUITE = "SSL_NULL_WITH_NULL_NULL";
    private static String DEFAULT_KEYSTORE_NAME = "./data/rcs/cacerts";
    private static String DEFAULT_KEYSTORE_PASSWORD = null;
    private static final SSLSocketFactory sslsf = TcpConnection.getSSLSocketWithDefaultKeystore();
    private static final SocketFactory sf = SocketFactory.getDefault();
    private static final SocketFactory[] factories = new SocketFactory[]{SocketFactory.getDefault(), sslsf, SocketFactory.getDefault(), SocketFactory.getDefault()};
    private ArrayList connectionParms;
    private int destination;
    private Socket currentSocket = null;
    private TcpConnectionParms currentParm = null;
    private int currentTries = 0;
    private boolean highPerformance;
    private boolean testSystem = true;
    private String countryCode = "US";
    private String subdivisionCode = "NY";

    public TcpConnection(int destination) throws IllegalArgumentException {
        if (destination > factories.length - 1) {
            throw new IllegalArgumentException("TcpConnection: invalid destination value '" + destination + "'");
        }
        this.destination = destination;
        try {
            this.getTcpConnectionParms();
        }
        catch (Exception e) {
            Trace.trace("XRSFTCPF", "TcpConnection.getTcpConnectionParms() exception:");
            Trace.trace("XRSFTCPF", e);
            throw new IllegalArgumentException("Problem with tcp connection parms");
        }
        Trace.trace("XRSFTCPT", "<> TcpConnection ctor created");
    }

    public TcpConnection(int destination, String countryCode, String subdivisionCode) throws IllegalArgumentException, HException {
        if (destination > factories.length - 1) {
            throw new IllegalArgumentException("TcpConnection: invalid destination value '" + destination + "'");
        }
        this.destination = destination;
        if (countryCode != null && countryCode.trim().length() != 0) {
            this.countryCode = countryCode;
            this.subdivisionCode = subdivisionCode;
        }
        this.getTcpConnectionParms();
        Trace.trace("XRSFTCPT", "<> TcpConnection ctor created");
    }

    public Socket getSocket() throws IOException {
        Trace.trace("XRSFTCPT", "TcpConnection.getSocket()");
        return this.establishConnection();
    }

    public boolean failSocket() {
        Trace.trace("XRSFTCPT", "-> TcpConnection::failSocket() for " + this.currentParm);
        if (this.currentParm == null) {
            Iterator i = this.connectionParms.iterator();
            while (i.hasNext()) {
                TcpConnectionParms parm = (TcpConnectionParms)i.next();
                if (!parm.isValid()) continue;
                Trace.trace("XRSFTCPF", "<- TcpConnection.failSocket found good parm: " + parm);
                return true;
            }
            return false;
        }
        this.terminateConnection();
        int currentTries = this.currentParm.getTries();
        this.currentParm.setTries(++currentTries);
        if (currentTries <= MAX_SOCKET_IO_RETRIES) {
            Trace.trace("XRSFTCPF", "<- TcpConnection.failSocket:true. Current Tries=" + this.currentParm.getTries());
            return true;
        }
        Trace.trace("XRSFTCPF", "TcpConnection.failSocket Current Tries=" + currentTries + ".  Will check for more addresses");
        boolean more = false;
        Iterator i = this.connectionParms.iterator();
        while (i.hasNext()) {
            TcpConnectionParms parm = (TcpConnectionParms)i.next();
            if (parm.equals(this.currentParm)) {
                Trace.trace("XRSFTCPF", "TcpConnection.failSocket current parm " + this.currentParm + " is now invalid");
                parm.setStatus(false);
                continue;
            }
            if (!parm.isValid()) continue;
            Trace.trace("XRSFTCPF", "TcpConnection.failSocket found new parm: " + parm);
            more = true;
        }
        Trace.trace("XRSFTCPT", "<- TcpConnection.failSocket(): " + more);
        return more;
    }

    private void getTcpConnectionParms() throws HException {
        String retainAddr = null;
        String serviceAgentAddr = null;
        String sasAddr = null;
        Object altRetainAddr = null;
        int retainPort = 0;
        int serviceAgentPort = 0;
        int sasPort = 0;
        boolean altRetainPort = false;
        int retainTimeout = 0;
        int serviceAgentTimeout = 0;
        int sasTimeout = 0;
        try {
            String timeout;
            String configPath = BaseFileControl.getFilePath("rcsconfig");
            File propsFile = new File(configPath, "targetInfo.props");
            Properties props = new Properties();
            props.load(new FileInputStream(propsFile));
            retainAddr = props.getProperty("RETAIN_ADDR");
            String rPort = props.getProperty("RETAIN_PORT");
            if (rPort != null) {
                retainPort = Integer.parseInt(rPort);
            }
            serviceAgentAddr = props.getProperty("SERVICE_AGENT_ADDR");
            String saPort = props.getProperty("SERVICE_AGENT_PORT");
            if (saPort != null) {
                serviceAgentPort = Integer.parseInt(saPort);
            }
            sasAddr = props.getProperty("SAS_ADDR");
            String aPort = props.getProperty("SAS_PORT");
            if (aPort != null) {
                sasPort = Integer.parseInt(aPort);
            }
            if ((timeout = props.getProperty("SERVICE_AGENT_TIMEOUT")) != null) {
                serviceAgentTimeout = Integer.parseInt(timeout);
            }
            if ((timeout = props.getProperty("SAS_TIMEOUT")) != null) {
                sasTimeout = Integer.parseInt(timeout);
            }
            if ((timeout = props.getProperty("RETAIN_TIMEOUT")) != null) {
                retainTimeout = Integer.parseInt(timeout);
            }
        }
        catch (Exception e) {
            Trace.trace("XRSFTCPD", "TcpConnection.getTcpConnectionParms Exception reading override file, targetInfo.props :" + e);
        }
        ConnectivityInfo connInfo = ConnectionInfoManager.getConnectionInfoManager().getConnectivityInfo(this.countryCode, this.subdivisionCode);
        ServerInfo servInfo = null;
        this.connectionParms = new ArrayList();
        if (this.destination == 0) {
            block26: {
                if (retainAddr != null && retainPort != 0) {
                    try {
                        this.connectionParms.add(new TcpConnectionParms(retainAddr, retainPort, retainTimeout));
                        Trace.trace("XRSFTCPT", "<- TcpConnection.getTcpConnectionParms: Using override RETAIN ip addr");
                        return;
                    }
                    catch (Exception e) {
                        Trace.trace("XRSFTCPF", "TcpConnection.getTcpConnectionParms: exception loading override RETAIN addr '" + retainAddr + ":" + retainPort + "'");
                    }
                }
                Trace.trace("XRSFTCPF", "TcpConnection.getTcpConnectionParms: Using account RETAIN ip parms");
                boolean foundRetainAddr = false;
                servInfo = connInfo.getServerInfo("Server_URSF_Primary");
                retainAddr = servInfo.getIpAddress();
                retainPort = servInfo.getPort();
                try {
                    this.connectionParms.add(new TcpConnectionParms(retainAddr, retainPort, retainTimeout));
                    Trace.trace("XRSFTCPF", "TcpConnection.getTcpConnectionParms: primary RETAIN addr added");
                    foundRetainAddr = true;
                }
                catch (Exception e) {
                    Trace.trace("XRSFTCPF", "TcpConnection.getTcpConnectionParms: exception loading primary RETAIN addr '" + retainAddr + ":" + retainPort + "'. " + e.getMessage());
                }
                servInfo = connInfo.getServerInfo("Server_URSF_Secondary");
                retainAddr = servInfo.getIpAddress();
                retainPort = servInfo.getPort();
                try {
                    this.connectionParms.add(new TcpConnectionParms(retainAddr, retainPort, retainTimeout));
                    Trace.trace("XRSFTCPF", "TcpConnection.getTcpConnectionParms: alternate RETAIN addr added");
                }
                catch (Exception e) {
                    Trace.trace("XRSFTCPF", "TcpConnection.getTcpConnectionParms: exception loading alternate RETAIN addr '" + retainAddr + ":" + retainPort + "'. " + e.getMessage());
                    if (foundRetainAddr) break block26;
                    throw new HException("TcpConnection: no valid RETAIN addresses found");
                }
            }
            return;
        }
        if (this.destination == 1) {
            if (serviceAgentAddr == null || serviceAgentPort == 0) {
                Trace.trace("XRSFTCPF", "TcpConnection:getTcpConnectionParms: using non-override SA ip addr");
                servInfo = connInfo.getServerInfo("Server_SA");
                serviceAgentAddr = servInfo.getIpAddress();
                serviceAgentPort = servInfo.getPort();
            } else {
                Trace.trace("XRSFTCPF", "TcpConnection:getTcpConnectionParms: using override SA ip addr");
            }
            try {
                this.connectionParms.add(new TcpConnectionParms(serviceAgentAddr, serviceAgentPort, serviceAgentTimeout));
                Trace.trace("XRSFTCPT", "<- TcpConnection.getTcpConnectionParms: SA ip addr added '" + serviceAgentAddr + ":" + serviceAgentPort + "'");
                return;
            }
            catch (Exception e) {
                Trace.trace("XRSFTCPF", "TcpConnection.getTcpConnectionParms: exception loading SA ip addr '" + serviceAgentAddr + ":" + serviceAgentPort + "'");
                Trace.trace("XRSFTCPF", e);
                throw new HException("TcpConnection: no valid Service Agent addresses found");
            }
        }
        if (this.destination == 3) {
            if (sasAddr == null || sasPort == 0) {
                Trace.trace("XRSFTCPF", "TcpConnection:getTcpConnectionParms: using non-override SAS ip addr");
                servInfo = connInfo.getServerInfo("Server_SAS");
                sasAddr = servInfo.getIpAddress();
                sasPort = servInfo.getPort();
            } else {
                Trace.trace("XRSFTCPF", "TcpConnection:getTcpConnectionParms: using override SAS ip addr");
            }
            try {
                this.connectionParms.add(new TcpConnectionParms(sasAddr, sasPort, sasTimeout));
                Trace.trace("XRSFTCPT", "<- TcpConnection.getTcpConnectionParms: SAS ip addr added '" + sasAddr + ":" + sasPort + "'");
                return;
            }
            catch (Exception e) {
                Trace.trace("XRSFTCPF", "TcpConnection.getTcpConnectionParms: exception loading SAS ip addr '" + sasAddr + ":" + sasPort + "'");
                Trace.trace("XRSFTCPF", e);
                throw new HException("TcpConnection: no valid SAS addresses found");
            }
        }
        throw new HException("TcpConnection: invalid destination");
    }

    protected void freeResources() {
        Trace.trace("XRSFTCPT", "-> freeResources() for path ");
        Trace.trace("XRSFTCPT", "<- freeResources() Ok ");
    }

    private Socket establishConnection() throws IOException {
        Trace.trace("XRSFTCPT", "-> establishConnection()");
        Socket socket = null;
        Iterator i = this.connectionParms.iterator();
        while (i.hasNext()) {
            TcpConnectionParms parms = (TcpConnectionParms)i.next();
            Trace.trace("XRSFTCPF", "TcpConnection: attempting to get socket for " + parms.getAddress() + ":" + parms.getPort() + ". Tries completed=" + parms.getTries());
            if (!parms.isValid()) {
                Trace.trace("XRSFTCPF", "TcpConnection: no more tries for " + parms.getAddress() + ":" + parms.getPort());
                continue;
            }
            int retries = 0;
            boolean success = false;
            while (retries < MAX_SOCKET_CONNECT_RETRIES && !success) {
                Trace.trace("XRSFTCPF", "TcpConnection: establishConnection: establishment tries=" + retries);
                ++retries;
                try {
                    socket = parms.getPort() == 443 ? sslsf.createSocket(parms.getAddress(), parms.getPort()) : sf.createSocket(parms.getAddress(), parms.getPort());
                }
                catch (IOException e) {
                    Trace.trace("XRSFTCPT", "TcpConnection: Exception getting socket for " + parms + ". Invalidating connection address.");
                    Trace.trace("XRSFTCPT", e);
                    success = false;
                    try {
                        if (socket == null) continue;
                        socket.close();
                    }
                    catch (Exception ie) {
                        Trace.trace("XRSFTCPF", "TcpConnection: error closing failing socket");
                    }
                    continue;
                }
                if (socket instanceof SSLSocket) {
                    Trace.trace("XRSFTCPF", "TcpConnection: attempting to get session for SSLSocket");
                    SSLSession session = ((SSLSocket)socket).getSession();
                    if (session == null) {
                        Trace.trace("XRSFTCPF", "TcpConnection: null SSLSession");
                        success = false;
                        try {
                            if (socket == null) continue;
                            socket.close();
                        }
                        catch (Exception e) {
                            Trace.trace("XRSFTCPF", "TcpConnection: error closing failing socket");
                        }
                        continue;
                    }
                    String cipherSuite = session.getCipherSuite();
                    Trace.trace("XRSFTCPF", "TcpConnection: establish SSL: cipher suite=" + cipherSuite);
                    if (cipherSuite.equals(INVALID_CIPHER_SUITE)) {
                        success = false;
                        try {
                            if (socket == null) continue;
                            socket.close();
                        }
                        catch (Exception e) {
                            Trace.trace("XRSFTCPF", "TcpConnection: error closing failing socket");
                        }
                        continue;
                    }
                }
                success = true;
            }
            if (!success) {
                parms.setStatus(false);
                continue;
            }
            this.currentParm = parms;
            this.currentSocket = socket;
            int timeout = this.currentParm.getTimeout();
            if (timeout != 0) {
                socket.setSoTimeout(timeout);
            }
            Trace.trace("XRSFTCPT", "<- establishConnection() Ok with timeout=" + socket.getSoTimeout());
            return socket;
        }
        Trace.trace("XRSFTCPT", "<- establishConnectionk() EXC: All connection alternatives failed");
        throw new IOException("Could not establish connection; all alternatives failed");
    }

    protected void terminateConnection() {
        Trace.trace("XRSFTCPT", "-> terminateConnection() for " + this.currentParm);
        if (this.currentSocket != null) {
            try {
                this.currentSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.currentSocket = null;
        Trace.trace("XRSFTCPT", "<- terminateConnection() Ok");
    }

    public boolean isHighPerformance() {
        return this.highPerformance;
    }

    public void setHighPerformance(boolean value) {
        this.highPerformance = value;
    }

    public static SSLSocketFactory getSSLSocketWithDefaultKeystore() {
        Trace.trace("XRSFTCPF", "TcpConnection:getSSLSocketWithDefaultKeystore for" + DEFAULT_KEYSTORE_NAME);
        return TcpConnection.getSSLSocketWithKeystore(DEFAULT_KEYSTORE_NAME, DEFAULT_KEYSTORE_PASSWORD);
    }

    public static SSLSocketFactory getSSLSocketWithKeystore(String keystoreName, String password) {
        char[] passchars = null;
        if (password != null) {
            passchars = password.toCharArray();
        }
        try {
            Trace.trace("XRSFTCPT", "-> TcpConnection::getSSLSocketWithKeystore()");
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            Trace.trace("XRSFTCPF", "TcpConnection::getSSLSocketWithKeystore() loading keystore '" + keystoreName + "'");
            ks.load(new FileInputStream(keystoreName), passchars);
            Trace.trace("XRSFTCPF", "TcpConnection::getSSLSocketWithKeystore() getting KeyManagerFactory instance");
            KeyManagerFactory kmFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            Trace.trace("XRSFTCPF", "TcpConnection::getSSLSocketWithKeystore() initializing KeyManagerFactory with keystore");
            kmFactory.init(ks, passchars);
            Trace.trace("XRSFTCPF", " TcpConnection::getSSLSocketWithKeystore() getting SSLContext instance");
            SSLContext context = SSLContext.getInstance("TLS");
            Trace.trace("XRSFTCPF", " TcpConnection::getSSLSocketWithKeystore() initializing SSLContext with keystore");
            context.init(kmFactory.getKeyManagers(), null, null);
            Trace.trace("XRSFTCPF", " TcpConnection::getSSLSocketWithKeystore() getting SSLSocket from SSLContext");
            return context.getSocketFactory();
        }
        catch (Exception e) {
            Trace.trace("XRSFTCPF", "TcpConnection::getSSLSocketWithKeystore() exception caught");
            Trace.trace("XRSFTCPF", e);
            Trace.trace("XRSFTCPF", "TcpConnection:: must use default socket factory");
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
    }

    static {
        try {
            DEFAULT_KEYSTORE_NAME = BaseFileControl.getFilePath("rcsconfig") + "cacerts";
        }
        catch (Exception e) {
            Trace.trace("XRSFTCPF", "TcpConnection: unable to get filepath for keystore");
        }
    }
}

